package cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute;

import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.AttributeTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateAttributeParam implements Serializable {

    private static final long serialVersionUID = 5774047826413134184L;
    /**
     * 修改属性值
     */
    List<UpdateAttributeValueParam> updateAttributeValues;
    private String attributeName;
    /**
     * 新增属性值
     */
    private List<String> attributeValues;
    /**
     * 删除属性值
     */
    private List<String> attrIds;

    /**
     * 类目ID
     */
    @NotEmpty(message = "类目Id不能为空")
    private Set<Long> categoryIds;

    @NotNull(message = "属性ID不能为空")
    private Long id;

    /**
     * 属性类型
     * {@link AttributeTypeEnum}
     */
    private Integer attrType;
}
