package cn.com.duiba.cloud.zhongyan.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.AttributeStateEnum;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.attribute.AttributeDTO;
import cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute.AddAttributeParam;
import cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute.AttributeQueryParam;
import cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute.QueryAttributeByCategoryIdParam;
import cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute.UpdateAttributeParam;
import cn.com.duiba.wolf.entity.PageResponse;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
@SuppressWarnings("unused")
public interface RemoteAttributeService {

   /**
    * 属性查询
    *
    * @param param 查询参数
    * @return AttributeDTO
    */
   PageResponse<AttributeDTO> queryAttribute(AttributeQueryParam param);

   /**
    * 启用/关闭属性
    *
    * @param attributeId 属性ID
    * @param state       开启/关闭 {@link AttributeStateEnum}
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean enableAttribute(Long attributeId, Integer state) throws BizException;

   /**
    * 删除属性
    *
    * @param attributeId 属性ID
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean deleteAttribute(Long attributeId) throws BizException;

   /**
    * 添加属性
    * @param addAttributeParam 参数
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean addAttribute(AddAttributeParam addAttributeParam) throws BizException;

   /**
    * 更新属性数据
    *
    * @param updateAttributeParam 更新参数
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean updateAttribute(UpdateAttributeParam updateAttributeParam) throws BizException;

   /**
    * 判断属性是否正在使用中
    *
    * @param attrId 属性ID
    * @return 是否正在使用
    * @throws BizException 业务异常
    */
   Boolean isUsing(Long attrId) throws BizException;

   /**
    * 根据属性ID获取属性
    *
    * @param attributeIds 根据属性IDs
    * @return 属性
    * @throws BizException 业务异常
    */
   List<AttributeDTO> getAttributesByIds(List<Long> attributeIds) throws BizException;

   /**
    * 删除属性类目关联
    *
    * @param mappingId 关联ID
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean deleteAttributeCategoryMapping(Long mappingId) throws BizException;

   /**
    * 删除属性类目关联 根据属性ID 和类目ID
    * @param attributeId 属性ID
    * @param categoryId 类目ID
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean deleteMappingByAttrIdAndCateId(Long attributeId,Long categoryId) throws BizException;

   /**
    * 根据类目查询属性列表
    * @param param 属性参数
    * @return 分页类目属性
    */
   PageResponse<AttributeDTO> queryAttributeByCategoryId(@RequestBody @Valid QueryAttributeByCategoryIdParam param)
       throws BizException;

   /**
    * 根据ID查询类目详情
    * @param attributeId 属性ID
    * @return 类目详情
    * @throws BizException 业务异常
    */
   AttributeDTO getById(Long attributeId) throws BizException;
}
