package cn.com.duiba.cloud.zhongyan.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.sale.SpuSaleDetailDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.sale.SpuSaleDto;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 上架项服务
 *
 * @author zsp (zengshuipinAduiba.com.cn)
 * @date 2021/11/10 11:17 上午
 */
@AdvancedFeignClient
public interface RemoteSpuSaleService {
    /**
     * 上架项列表
     *
     * @return
     */
    PageResponse<SpuSaleDto> list();

    /**
     * 上架项详情
     *
     * @return
     */
    SpuSaleDetailDto detail();

    /**
     * 上架项选品
     *
     * @return
     */
    Boolean cloneSpuSale();

    /**
     * 删除上架项
     *
     * @return
     */
    Boolean deleteSpuSale();
}
