/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSourceEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SkuDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SpuDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class GoodsDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(label="snapshot")
    private SpuDto spuDto;
    @JSONField(label="snapshot")
    private List<SkuDto> skuList;

    public static GoodsSourceEnum getGoodsSource(GoodsDto goodsDto) {
        return GoodsSourceEnum.getGoodsSourceEnum(goodsDto.getSpuDto().getUserId(), goodsDto.getSpuDto().getDetail().getUserId());
    }

    public boolean selfGoods(CurTenantParam param) {
        return Objects.equals(this.getSpuDto().getUserId(), param.getCurUserId()) && Objects.equals(this.getSpuDto().getUserType(), param.getCurUserType());
    }

    public boolean isDeleted() {
        return this.spuDto == null || this.spuDto.getDetail() == null;
    }

    public String generateSnapshotId() {
        return GoodsSnapshotUtil.getSnapshotId(this);
    }

    public void setSpuDto(SpuDto spuDto) {
        this.spuDto = spuDto;
    }

    public void setSkuList(List<SkuDto> skuList) {
        this.skuList = skuList;
    }

    public SpuDto getSpuDto() {
        return this.spuDto;
    }

    public List<SkuDto> getSkuList() {
        return this.skuList;
    }
}

