package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 商品来源下拉框枚举
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/3/19 16:43
 */
@Getter
public enum AllGoodsSourceEnum implements IEnum<Long> {

    /**
     * 商品来源
     */
    DUIBA(111L, "自营"),

    /**
     * 兼容 {@link GoodsSourceEnum#DE_LI}
     */
    DE_LI(112L, "得力"),

    /**
     * 兼容 {@link GoodsSourceEnum#SU_NING}
     */
    SU_NING(113L, "苏宁")
    ;

    AllGoodsSourceEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 商品来源id
     */
    private final Long code;
    private final String desc;

    /**
     * 是否是第三方商品
     * @param sourceId
     * @return
     */
    public static boolean isThirdGoods(Long sourceId) {
        return AllGoodsSourceEnum.DE_LI.getCode().equals(sourceId) || AllGoodsSourceEnum.SU_NING.getCode().equals(sourceId);
    }

    @Override
    public Long getDbCode() {
        return getCode();
    }
}
