package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

import java.util.Objects;

/**
 * 商品来源
 * 计算得出
 *
 * ps: 订单中存储的商品来源枚举
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/29 19:03
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum GoodsSourceEnum implements IEnum<Integer> {
    OWN(1, "自有商品"),
    /**
     * 兑吧也是供应商一员
     */
    SUPPLIER(2, "供应商商品"),

    /**
     * {@link AllGoodsSourceEnum#DE_LI}
     */
    DE_LI(3, "得力"),

    /**
     * {@link AllGoodsSourceEnum#SU_NING}
     */
    SU_NING(4, "苏宁")
    ;


    private final Integer code;
    private final String desc;

    GoodsSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getCode();
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static GoodsSourceEnum getEnum(Integer code) {
        for (GoodsSourceEnum value : GoodsSourceEnum.values()) {
            if (Objects.equals(value.code, code)) {
                return value;
            }
        }
        return null;
    }

    /**
     * 商品来源
     * 通过计算两个user得出
     * 能操作商品的userType只能是租户，当不满足此条件时应另起方法
     *
     * @return cn.com.duiba.cloud.zhongyan.goods.service.api.constant.GoodsSource
     */
    @Deprecated
    public static GoodsSourceEnum getGoodsSourceEnum(Long userId1, Long userId2) {
        if (Objects.equals(userId1, userId2)) {
            return GoodsSourceEnum.OWN;
        }
        return GoodsSourceEnum.SUPPLIER;
    }

    /**
     * 目前直接通过商品userId判断商品来源
     *
     * @param sourceId 商品来源
     * @return
     */
    public static GoodsSourceEnum getGoodsSourceEnum(Long sourceId) {
        if (Objects.isNull(sourceId) || AllGoodsSourceEnum.DUIBA.getCode().equals(sourceId)) {
            return GoodsSourceEnum.OWN;
        } else if (AllGoodsSourceEnum.DE_LI.getCode().equals(sourceId)) {
            return GoodsSourceEnum.DE_LI;
        } else if (AllGoodsSourceEnum.SU_NING.getCode().equals(sourceId)) {
            return GoodsSourceEnum.SU_NING;
        }
        return null;
    }

    /**
     * 通过goodsSource反查sourceId
     *
     * @param goodsSource
     * @return
     */
    public static Long getSourceIdByGoodsSource(Integer goodsSource) {
        if (GoodsSourceEnum.OWN.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.DUIBA.getCode();
        } else if (GoodsSourceEnum.DE_LI.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.DE_LI.getCode();
        } else if (GoodsSourceEnum.SU_NING.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.SU_NING.getCode();
        }
        return null;
    }
}
