package cn.com.duiba.cloud.duiba.goods.center.api.param.attribute;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddAttributeParam implements Serializable {

    private static final long serialVersionUID = -1822643526521967870L;
    @NotNull(message = "属性类型不能为空")
    private Integer attrType;

    @NotBlank(message = "属性值不能为空")
    @Size(max = 10,message = "属性名称最大10个字符")
    private String attributeName;

    @Size(max = 50,min = 1,message = "属性值最多添加50个且不能为空")
    @NotNull(message = "属性值不能为空")
    private List<String> attributeValue;

    /**
     * 是否搜索
     */
    private Integer isSearch;

    /**
     * 是否必填
     */
    private Integer isRequired;

    private Integer multipleSelect;

    @NotEmpty(message = "类目ID不能为空")
    private List<Long> categoryIds;
}
