package cn.com.duiba.cloud.duiba.goods.center.api.param.attribute;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttributeTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateAttributeParam implements Serializable {

    private static final long serialVersionUID = 5774047826413134184L;
    /**
     * 修改属性值
     */
    List<UpdateAttributeValueParam> updateAttributeValues;

    @Size(max = 10,message = "属性名称最大10个字符")
    private String attributeName;

    /**
     * 新增属性值
     */
    @Size(max = 50,message = "属性值最多添加50个")
    private List<String> attributeValues;

    /**
     * 删除属性值
     */
    private List<String> attrIds;

    /**
     * 类目ID
     */
    @NotEmpty(message = "类目Id不能为空")
    private Set<Long> categoryIds;

    @NotNull(message = "属性ID不能为空")
    private Long id;
    
    /**
     * 属性类型 {@link AttributeTypeEnum}
     */
    private Integer attrType;
}
