/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.SnapshotTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Date;

public class GoodsSnapshotDto
extends BaseDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String snapshotValue;
    private Long spuId;
    private Long userId;
    private Date snapshotVersion;
    private Integer snapshotType;

    public GoodsSnapshotDto(Long spuId, Long userId, Date snapshotVersion, SnapshotTypeEnum snapshotTypeEnum, String snapshotValue) {
        this(spuId, userId, snapshotVersion, snapshotTypeEnum);
        this.setSnapshotValue(snapshotValue);
    }

    public GoodsSnapshotDto(Long spuId, Long userId, Date snapshotVersion, SnapshotTypeEnum snapshotTypeEnum) {
        this();
        this.setSpuId(spuId);
        this.setUserId(userId);
        this.setSnapshotVersion(snapshotVersion);
        this.setSnapshotType(snapshotTypeEnum.getSnapshotType());
    }

    public GoodsSnapshotDto() {
    }

    public void setSnapshotVersion(Date snapshotVersion) {
        this.snapshotVersion = new Date(snapshotVersion.getTime() / 1000L * 1000L);
    }

    public static void main(String[] args) {
        SnapshotTypeEnum snapshotTypeEnum = SnapshotTypeEnum.SUPPLIER;
        GoodsSnapshotDto goodsSnapshotDto = new GoodsSnapshotDto(1L, 2L, new Date(), snapshotTypeEnum);
        System.out.println(JSON.toJSONString((Object)goodsSnapshotDto));
        GoodsSnapshotDto convert = GoodsSnapshotDto.convert(goodsSnapshotDto.getSnapshotId(), snapshotTypeEnum);
        System.out.println(JSON.toJSONString((Object)convert));
    }

    public static GoodsSnapshotDto convert(String snapshotId, SnapshotTypeEnum snapshotTypeEnum) {
        String[] split = snapshotId.split("_");
        return new GoodsSnapshotDto(Long.valueOf(split[0]), Long.valueOf(split[2]), new Date(Long.parseLong(split[1]) * 1000L), snapshotTypeEnum);
    }

    public String getSnapshotId() {
        return String.format("%s_%s_%s_%s", this.spuId, this.getDateSecond(this.getSnapshotVersion()), this.userId, this.snapshotType);
    }

    private Long getDateSecond(Date snapshotVersion) {
        return snapshotVersion.getTime() / 1000L;
    }

    public void setSnapshotValue(String snapshotValue) {
        this.snapshotValue = snapshotValue;
    }

    public void setSpuId(Long spuId) {
        this.spuId = spuId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setSnapshotType(Integer snapshotType) {
        this.snapshotType = snapshotType;
    }

    public String getSnapshotValue() {
        return this.snapshotValue;
    }

    public Long getSpuId() {
        return this.spuId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Date getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public Integer getSnapshotType() {
        return this.snapshotType;
    }
}

