package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/23 10:32
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum ReviewStatusEnum implements IEnum<Integer> {
    PASS(1),
    WAIT(2),
    FAIL(3),
    ;


    /**
     * 审核状态(1:正常,2:待审核,3:审核失败)
     */
    private final Integer reviewStatus;

    ReviewStatusEnum(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    @Override
    public Integer getDbCode() {
        return getReviewStatus();
    }
}
