package cn.com.duiba.cloud.duiba.goods.center.api.dto.attribute;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttributeStateEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttributeTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 属性
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AttributeDTO implements Serializable {

    private static final long serialVersionUID = 6378497379227620887L;

    private Long id;

    /**
     * 属性项
     */
    private String attrName;

    /**
     * 属性值
     */
    private List<AttributeValueDTO> attributeValues;

    /**
     * 属性类型 {@link AttributeTypeEnum}
     */
    private Integer attrType;

    /**
     * 状态 {@link AttributeStateEnum}
     */
    private Integer state;

    /**
     * 类目id
     */
    private List<Long> categoryIds;

    /**
     * 映射ID
     */
    private Long mappingId;

    /**
     * 映射关系创建时间
     */
    private Date createDate;

}
