package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:36 下午
 */
@Getter
@Setter
public class SpuDto extends AbstractGoodsDto implements UserBiz {
    private static final long serialVersionUID = 1L;
    /**
     * 品牌id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long brandId;
    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     *
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer spuType;
    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer userType;
    /**
     * 用户id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long userId;
    /**
     * 商品状态(1:正常商品, 2:草稿箱商品, 3:审核中,4:审核失败)
     *
     * @see SpuStatusEnum
     */
    private Integer spuStatus;
    /**
     * 叶子类目
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long leafCategoryId;


    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return getId();
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SPU.getGeneralType();
    }

    public boolean selfSpu(CurTenantParam param) {
        return Objects.equals(this.getUserType(), param.getCurUserType())
                && Objects.equals(this.getUserId(), param.getCurUserId());
    }
}
