/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.AllGoodsSourceEnum;
import java.util.Objects;

public enum GoodsSourceEnum implements IEnum<Integer>
{
    OWN(1, "\u81ea\u6709\u5546\u54c1"),
    SUPPLIER(2, "\u4f9b\u5e94\u5546\u5546\u54c1"),
    DE_LI(3, "\u5f97\u529b"),
    SU_NING(4, "\u82cf\u5b81");

    private final Integer code;
    private final String desc;

    private GoodsSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getDbCode() {
        return this.getCode();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static GoodsSourceEnum getEnum(Integer code) {
        for (GoodsSourceEnum value : GoodsSourceEnum.values()) {
            if (!Objects.equals(value.code, code)) continue;
            return value;
        }
        return null;
    }

    @Deprecated
    public static GoodsSourceEnum getGoodsSourceEnum(Long userId1, Long userId2) {
        if (Objects.equals(userId1, userId2)) {
            return OWN;
        }
        return SUPPLIER;
    }

    public static GoodsSourceEnum getGoodsSourceEnum(Long sourceId) {
        if (Objects.isNull(sourceId) || AllGoodsSourceEnum.DUIBA.getCode().equals(sourceId)) {
            return OWN;
        }
        if (AllGoodsSourceEnum.DE_LI.getCode().equals(sourceId)) {
            return DE_LI;
        }
        if (AllGoodsSourceEnum.SU_NING.getCode().equals(sourceId)) {
            return SU_NING;
        }
        return null;
    }

    public static Long getSourceIdByGoodsSource(Integer goodsSource) {
        if (OWN.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.DUIBA.getCode();
        }
        if (DE_LI.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.DE_LI.getCode();
        }
        if (SU_NING.getCode().equals(goodsSource)) {
            return AllGoodsSourceEnum.SU_NING.getCode();
        }
        return null;
    }
}

