/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.MediaTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.AbstractGoodsDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsAttributeDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsDetailDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SimpleAttributeDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SkuDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SpuDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSnapshot;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SimpleSkuDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String snapshotId;
    private Long spuId;
    private Long skuId;
    private Integer spuType;
    private String smallImage;
    private String mainImage;
    private String title;
    private List<SimpleAttributeDto> attr = new ArrayList<SimpleAttributeDto>();

    public SimpleSkuDto(GoodsSnapshot goodsSnapshot, GoodsDto goodsDto, Long skuId) {
        this();
        this.setSnapshotId(goodsSnapshot.getSnapshotId());
        SpuDto spuDto = goodsDto.getSpuDto();
        this.setSpuId(spuDto.getId());
        this.setSkuId(skuId);
        this.setSpuType(spuDto.getSpuType());
        ArrayList abstractGoodsDtoList = Lists.newArrayList((Object[])new AbstractGoodsDto[]{spuDto});
        Optional<SkuDto> optional = goodsDto.getSkuList().stream().filter(skuDto -> Objects.equals(skuDto.getId(), skuId)).findFirst();
        if (optional.isPresent()) {
            SkuDto skuDto2 = optional.get();
            List<GoodsAttributeDto> attributeList = skuDto2.getAttributeList();
            this.setAttr(attributeList.stream().map(SimpleAttributeDto::new).collect(Collectors.toList()));
            abstractGoodsDtoList.add(skuDto2);
        }
        for (AbstractGoodsDto abstractGoodsDto : abstractGoodsDtoList) {
            String title;
            List<String> mainImageList;
            List<String> smallImageList = abstractGoodsDto.getImageByImageType(MediaTypeEnum.IMAGE_SMALL);
            if (CollectionUtils.isNotEmpty(smallImageList)) {
                this.setSmallImage(smallImageList.get(0));
            }
            if (CollectionUtils.isNotEmpty(mainImageList = abstractGoodsDto.getImageByImageType(MediaTypeEnum.IMAGE))) {
                this.setMainImage(mainImageList.get(0));
            }
            if (!StringUtils.isNotBlank((String)(title = (String)Optional.ofNullable(abstractGoodsDto.getDetail()).map(GoodsDetailDto::getGeneralName).orElse(null)))) continue;
            this.setTitle(title);
        }
    }

    public SimpleSkuDto() {
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSpuId(Long spuId) {
        this.spuId = spuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public void setMainImage(String mainImage) {
        this.mainImage = mainImage;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAttr(List<SimpleAttributeDto> attr) {
        this.attr = attr;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Long getSpuId() {
        return this.spuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public Integer getSpuType() {
        return this.spuType;
    }

    public String getSmallImage() {
        return this.smallImage;
    }

    public String getMainImage() {
        return this.mainImage;
    }

    public String getTitle() {
        return this.title;
    }

    public List<SimpleAttributeDto> getAttr() {
        return this.attr;
    }
}

