package cn.com.duiba.cloud.zhongyan.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.CreateAddressParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.CreateOrderAddressParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.UpdateAddressParam;

/**
 * @Description 用户地址相关写操作接口
 * @Author dangcang
 * @Date 2021/11/11 10:36 上午
 **/
@AdvancedFeignClient
public interface RemoteAddressWriteService {

    /**
     * 创建用户收货地址接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean createUserAddress(CreateAddressParam param) throws BizException;

    /**
     * 更新用户收货地址接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateUserAddress(UpdateAddressParam param) throws BizException;

    /**
     * 删除用户收货地址接口
     * @param userAddressId
     * @return
     * @throws BizException
     */
    Boolean deleteUserAddress(Long userAddressId) throws BizException;

    /**
     * 创建订单地址
     * @param param
     * @return
     * @throws BizException
     */
    Boolean createOrderAddress(CreateOrderAddressParam param) throws BizException;

}