package cn.com.duiba.cloud.zhongyan.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.ConfirmOrderParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.PayDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.CancelOrderParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.OrderCreateParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.OrderRemarkParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.OrderRemindParam;

/**
 * @Description 订单相关写操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:35 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderWriteService {

    /**
     * 创建订单
     * @param param
     * @return
     * @throws BizException
     */
    PayDTO createOrder(OrderCreateParam param) throws BizException;

    /**
     * 用户子订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userSubOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 订单确认
     * @param param
     * @return
     * @throws BizException
     */
    Boolean orderConfirm(ConfirmOrderParam param) throws BizException;

    /**
     * 租户订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean tenantOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 取消订单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean cancelOrder(CancelOrderParam param) throws BizException;

    /**
     * 用户提醒接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userOrderRemind(OrderRemindParam param) throws BizException;
}