package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.DispatchBillStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 发货单
 * @Author dangcang
 * @Date 2021/11/18 12:02 下午
 **/
@Data
public class DispatchBillDTO implements Serializable {

    /**
     * 发货单id
     */
    private Long DispatchBillId;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Integer orderSort;

    /**
     * 地址id
     */
    private OrderAddressDTO orderAddressDTO;

    /**
     * 物流单id
     */
    private Long logisticsId;

    /**
     * 快递公司
     */
    private String logisticsCompany;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 发货单状态
     * @see DispatchBillStatusEnum
     */
    private Integer dispatchBillStatus;

    /**
     * 发货人
     */
    private String deliveryName;

    /**
     * 发货时间
     */
    private Long deliveryTime;
}