package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 用户订单详情
 * @Author dangcang
 * @Date 2021/11/16 6:33 下午
 **/
@Data
public class UserOrderDetailDTO implements Serializable {

    private static final long serialVersionUID = -5316707464186147894L;
    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private Long bizId;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;

    /**
     * 取消订单原因
     */
    private String failReason;

    /**
     * appId
     */
    private Long appId;

    /**
     * 商品基础信息
     */
    private List<SubOrderDetailDTO> subOrderDetailDTOS;

}