package cn.com.duiba.collect.card.center.api.dto.request;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;

public class AsyncCollectCardRequest implements Serializable {
    private static final long serialVersionUID = 5590372993324282089L;

    private Long consumerId;

    private Long appId;

    private Long itemId;

    private String partnerUserId;

    /**
     * 本次增加的卡片数量
     */
    private Integer itemNum;

    /**
     * 是否是助力成功发卡 true是 false不是
     */
    private boolean fromHelp;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public boolean isFromHelp() {
        return fromHelp;
    }

    public void setFromHelp(boolean fromHelp) {
        this.fromHelp = fromHelp;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public static AsyncCollectCardRequest decode(byte[] msg){
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string,AsyncCollectCardRequest.class);
    }

    public static byte[] encode(AsyncCollectCardRequest request) {
        String string = JSONObject.toJSONString(request);
        return string.getBytes(Charset.forName("utf-8"));
    }
}
