package cn.com.duiba.collect.card.center.api.enums;

import java.util.Arrays;

/**
 * Created by fangdong on 2019/02/26
 */
public enum CollectCardActivityAppTypeEnum {

    APP(0,"app"),
    WECHAT_OFFICIAL_ACCOUNT(1,"公众号"),
    ;

    CollectCardActivityAppTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static CollectCardActivityAppTypeEnum getByType(Integer type) {
        return Arrays.stream(values())
                .filter(value -> value.type.equals(type))
                .findFirst()
                .orElse(null);
    }

}
