package cn.com.duiba.collect.card.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.collect.card.center.api.dto.card.CollectCardInfoDTO;
import cn.com.duiba.collect.card.center.api.dto.request.CardTransferParam;
import cn.com.duiba.collect.card.center.api.dto.request.CollectCardDecrReqeust;

import java.util.List;

/**
 * RemoteCollectCardInfoService
 *
 * @author ChenXiangge
 * @date 2018/9/11
 */
@AdvancedFeignClient
public interface RemoteCollectCardInfoService {
    /**
     * 新增集卡数量-有则更新无则新增
     * @param cardInfoDTO
     * @return
     */
    Integer incrConsumerCard(CollectCardInfoDTO cardInfoDTO);

    /**
     * 新增集卡数量-有则更新无则新增
     * @param cardInfoDTO
     * @return
     */
    Integer incrConsumerCardForIqiyi(CollectCardInfoDTO cardInfoDTO,boolean isFromHelp);

    /**
     * 查询用户某张卡片数量
     * @param consumerId
     * @param itemId
     * @return
     */
    Integer findConsumerCardInfo(Long consumerId,Long itemId);

    /**
     * 批量查询用户特定卡片数量
     * @param consumerId
     * @param itemIds
     * @param itemType
     * @return
     */
    List<CollectCardInfoDTO> batchSearchConsumerCard(Long consumerId, List<Long> itemIds, Integer itemType);

    /**
     * 开奖 - 减去用户卡片数量
     * @param decrReqeust
     * @return
     */
    Integer batchDecrConsumerCard(CollectCardDecrReqeust decrReqeust) throws BizException;

    /**
     * 集卡转让
     * @param param
     * @return
     */
    Boolean transferCard(CardTransferParam param);

}
