package cn.com.duiba.collect.card.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.collect.card.center.api.dto.activity.CollectCardItemDto;
import cn.com.duiba.collect.card.center.api.param.activity.CollectCardItemSaveParam;

import java.util.List;

/**
 * Created by fangdong on 2019/03/04
 */
@AdvancedFeignClient
public interface RemoteCollectCardItemService {

    /**
     * 获取
     * @param id 卡片id
     * @return 卡片
     * @throws BizException
     */
    CollectCardItemDto getById(Long id) throws BizException;

    /**
     * 列表
     * @param ids 卡片列表id
     * @return 卡片列表
     * @throws BizException
     */
    List<CollectCardItemDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 保存卡片列表
     * @param items 卡片列表
     * @return 卡片id列表
     * @throws BizException
     */
    List<Long> saveList(List<CollectCardItemSaveParam> items) throws BizException;
}
