package cn.com.duiba.consumer.center.api.dto;

import cn.com.duiba.wolf.utils.UrlUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * Created by xiaoxuda on 2017/3/9.
 */
public class ConsumerExtraDto implements Serializable {
    private static final long serialVersionUID = -3206958279449585340L;

    /**
     * 支持用户定制的信息集合
     */
    public static final String[] INCLUDE_TAGS = {"nickname", "avatar"};

    private Long id;

    private Long consumerId;

    private Long appId;

    private String partnerUserId;

    private String nickname; // 昵称

    private String avatar; // 头像

    private String email; // 邮箱

    private Integer sex; // 性别 1男性 2女性

    private String json;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 判断dcustom是否包含支持用户定制的信息
     *
     * @param dcustom
     * @return
     */
    public static boolean ifSave(String dcustom) {
        if (StringUtils.isBlank(dcustom)) {
            return false;
        }
        Map<String, String> tagMap = explainDcustom(dcustom);
        for (String tag : INCLUDE_TAGS) {
            if (tagMap.containsKey(tag)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 解析用户的定制信息返回键值对数据
     *
     * @param dcustom
     * @return
     */
    public static Map<String, String> explainDcustom(String dcustom) {
        return UrlUtils.explainURLParams(dcustom);
    }
}
