package cn.com.duiba.consumer.center.api.params;


import cn.com.duiba.service.exception.BusinessException;

import java.io.Serializable;

/**
 * Created by liuyao on 2017/4/12.
 */
public class SignLogHistoryParams implements Serializable {

    private static final long serialVersionUID = -4718506621021731263L;
    private Long consumerId;
    private Long appId;
    private Integer offset;//可以为正,也可以为负,区间为+ — 30(天)
    private Integer size;//查询的天数 最大31
    private Integer todayCredits;//今天签到的积分

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getTodayCredits() {
        return todayCredits;
    }

    public void setTodayCredits(Integer todayCredits) {
        this.todayCredits = todayCredits;
    }

    /**
     * 校验参数
     * @throws BusinessException
     */
    public void verify() throws BusinessException {
        if(consumerId==null){
            throw new BusinessException("用户Id不能为空");
        }
        if(offset==null || offset>30 || offset<-30){
            throw new BusinessException("offset参数异常,value:"+offset);
        }
        if(size==null || size>31 || size<0){
            throw new BusinessException("size参数异常,value:"+size);
        }
    }
}
