/**
 * Project Name:activity-center-api
 * File Name:RemoteConsumerSignRecord.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.sign
 * Date:2016年11月4日下午7:02:43
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.SignRecordDto;

/**
 * 业务性不是很强,尽量调用RemoteSignSystemService中的服务
 * ClassName:RemoteConsumerSignRecord <br/>
 * Date:     2016年11月4日 下午7:02:43 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteSignRecordService {
    /**
     *
     * @param id
     * @param consumerId
     * @return
     */
    public SignRecordDto find(Long id, Long consumerId);

    /**
     *
     * @param consumerId
     * @return
     */
    public SignRecordDto findByConsumerId(Long consumerId);

    /**
     *
     * @param record
     * @return
     */
    SignRecordDto insert(SignRecordDto record);

    /**
     *
     * @param record
     * @return
     */
    Integer update(SignRecordDto record);
}

