package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.WeUserDto;
import cn.com.duiba.consumer.center.api.paramQuery.UserQueryParams;

import java.util.List;

/**
 * @author fengyibo
 * @date 2018/10/16 10:19
 */
@AdvancedFeignClient
public interface RemoteWeUserService {

    /**
     * 分页查询user
     * @param params
     * @return
     */
    List<WeUserDto> findUserListByPage(UserQueryParams params);

    /**
     * 批量查询用户信息
     * @param appKey
     * @param uids
     * @return
     */
    List<WeUserDto> findListByOpenId(String appKey, List<String> uids);

    /**
     * 根据条件查询用户总数
     * @param params
     * @return
     */
    Long findUserCount(UserQueryParams params);

    /**
     * 根据appKey和openId查询用户
     * @param appKey
     * @param openId
     * @return
     */
    WeUserDto getByAppKeyAndOpenId(String appKey, String openId);

}
