package cn.com.duiba.consumer.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2018/09/30
 */
public class ConsumerCreditsLogParamDto implements Serializable {
    private static final long serialVersionUID = 4055412520633310694L;

    /**
     * consumer id
     * required
     */
    private Long consumerId;

    /**
     * 订单业务类型，兑换类型：alipay(支付宝), qb(Q币), coupon(优惠券), object(实物), phonebill(话费), phoneflow(流量),
     * virtual(虚拟商品),game(游戏), hdtool(活动抽奖),sign(签到)，reSign(补签)所有类型不区分大小写
     */
    private String bizType;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 变动类型，1：消耗，2：增加
     */
    private Integer changeType;

    /**
     * 起始下单时间
     */
    private Date beginOrderTime;

    /**
     * 结束下单时间
     */
    private Date endOrderTime;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getBeginOrderTime() {
        return beginOrderTime;
    }

    public void setBeginOrderTime(Date beginOrderTime) {
        this.beginOrderTime = beginOrderTime;
    }

    public Date getEndOrderTime() {
        return endOrderTime;
    }

    public void setEndOrderTime(Date endOrderTime) {
        this.endOrderTime = endOrderTime;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    @Override
    public String toString() {
        return "ConsumerCreditsLogParamDto{" +
                "consumerId=" + consumerId +
                ", bizType='" + bizType + '\'' +
                ", bizId='" + bizId + '\'' +
                ", changeType=" + changeType +
                ", beginOrderTime=" + beginOrderTime +
                ", endOrderTime=" + endOrderTime +
                '}';
    }
}
