package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerUnifiledAccoutDto;
import cn.com.duiba.consumer.center.api.enums.SourceTypeEnum;

/**
 * Created by 刘凯 on 18/10/10.
 */
@AdvancedFeignClient
public interface RemoteUnifieldAccountService {


	/**
	 * 保存
	 * @param  consumerUnifiledAccoutDto
	 * @return  Long
	 */
    public Integer insert(ConsumerUnifiledAccoutDto consumerUnifiledAccoutDto);


    /**
     * 根据唯一键查询
     * @param   uid  uid值,
     * @param   sourceId 三方app在兑吧平台的标识，三方app时填入app_id，兑吧自有时填入"phone"，兑吧公众号时填入公众号的appKey,
     * @param   SourceTypeEnum 用户来源渠道，1：三方app，2：兑吧公众号，3：兑吧注册用户
     * @return  Long
     */
    public ConsumerUnifiledAccoutDto findBySourceidAndTypeAndUidMd5(String uid,String sourceId,SourceTypeEnum sourceTypeEnum);



	/**
	 * 保存
	 * @param  consumerUnifiledAccoutDto
	 * @return  Long
	 */
	public Integer updateById(ConsumerUnifiledAccoutDto consumerUnifiledAccoutDto);

}
