package cn.com.duiba.consumer.center.api.enums;

public enum SourceTypeEnum {

    THIRD_APP(1,"三方app"),
    DUIBA_OFFICIAL_ACCOUNTS(2,"兑吧公众号"),
    DUIBA_REGISTER(3,"兑吧注册用户"),
    DUIBA_MINIPROGRAMER(4,"代理小程序用户"),
            ;

    private Integer type;
    private String desc;

    SourceTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static SourceTypeEnum getByType(Integer type){
        for(SourceTypeEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
