package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ReceiveAddressDto;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2018/11/19
 */
@AdvancedFeignClient
public interface RemoteReceiveAddressService {

    //通过consumerId查询收货信息列表
    List<ReceiveAddressDto> listReceiveAddressByConsumerId(Long consumerId);

    //通过consumerId查询默认收货信息
    ReceiveAddressDto getDefaultReceiveAddressByConsumerId(Long consumerId);
    List<ReceiveAddressDto> getDefaultReceiveAddressByConsumerIds(List<Long> consumerIds);

    //通过consumerId查询收货信息（为了兼容升级地址库之前的地址数据）
    ReceiveAddressDto getReceiveAddressCompatible(Long consumerId);

    /**
     * 根据id查询地址
     * @param id
     * @return
     */
    ReceiveAddressDto getReceiveAddressById(Long id);


    /**
     * 根据id 删除地址
     * @param id  地址id
     * @return
     */
    void delAddressById(Long id);

    /**
     * 新增收货信息(最新)
     * @param receiveAddressDto
     * @return id
     */
    long insertAddressNew(ReceiveAddressDto receiveAddressDto);


    /**
     * 更新收货信息(最新)
     * @param receiveAddressDto
     * @return id
     */
    long updateAddressNew(ReceiveAddressDto receiveAddressDto);


}
