package cn.com.duiba.consumer.center.api.enums;

public enum AccountStatusEnum {

    UNACTIVATE(0,"未激活"),
    ACTIVATE(1,"激活");

    private Integer type;
    private String desc;

    AccountStatusEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static AccountStatusEnum getByType(Integer type){
        for(AccountStatusEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
