package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.DuibaTrusteeshipUserDto;
import cn.com.duiba.consumer.center.api.dto.DuibaTrusteeshipUserProcessDto;
import cn.com.duiba.consumer.center.api.paramQuery.trusteeshipuser.UserParam;

import java.util.List;

/**
 * @author haojiahong
 * @date 2022-09-22
 */
@AdvancedFeignClient
public interface RemoteDuibaTrusteeshipUserService {

    /**
     * 查询初始用户（还未登录到兑吧）
     *
     * @param appId
     * @param uid
     * @return
     */
    DuibaTrusteeshipUserDto findInitUserByAppIdUid(Long appId, String uid);

    /**
     * 对初始用户完成初始化
     * 免登后调用处理
     *
     * @param trusteeshipUserDto
     * @return
     */
    Boolean completeInitUser(DuibaTrusteeshipUserDto trusteeshipUserDto);


    /**
     * 通过条件查询用户记录
     *
     * @param param
     * @return
     */
    List<DuibaTrusteeshipUserDto> findListByCondition(UserParam param);

    /**
     * 通过条件查询用户记录数
     *
     * @param param
     * @return
     */
    Integer countByCondition(UserParam param);


    /**
     * 查询用户
     * @param appId
     * @param uid
     * @return
     */
    DuibaTrusteeshipUserDto findUserByAppIdUid(Long appId, String uid);

    /**
     * 加积分
     *
     * @param appId
     * @param uid
     * @param credits
     * @return
     */
    DuibaTrusteeshipUserProcessDto addCredits(Long appId, String uid, Long credits);

    /**
     * 减积分
     *
     *
     * @param appId
     * @param uid
     * @param credits
     * @return
     */
    DuibaTrusteeshipUserProcessDto subCredits(Long appId, String uid, Long credits);

}
