package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.MobileCustomernoRelationDto;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteMobileCustomernoRelationService {

	/**
	 * 插入一条数据
	 *
	 * @param mobileCustomernoRelationDto
	 * @return id
	 */
	Long insert(MobileCustomernoRelationDto mobileCustomernoRelationDto);

	/**
	 * 根据id更新手机号
	 *
	 * @param id
	 * @param mobile
	 * @return
	 */
	Integer updateMobileById(Long id, String mobile);


	/**
	 * @param type=1 key为手机号  type=2 key 为客户号
	 * @param key
	 * @return 关系对象
	 */
	MobileCustomernoRelationDto findByMobileOrCustomerno(Integer type, String key);

	/**
	 * 通过手机号找最新的客户号列表
	 *
	 * @param phones
	 * @return
	 */
	List<MobileCustomernoRelationDto> listByMobiles(Set<String> phones);


}
