package cn.com.duiba.consumer.center.api.dto;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * Created by wenqi.huang on 16/4/7.
 */
public class ConsumerDto implements Serializable{
    private static final long serialVersionUID = 1231200L;
    public static final String PREVIEWUSERID="duiba-preview-user"; //用来进行预览的用户id
	public static final String NOTLOGINUSERID = "not_login";	//未登录用户id
    public static final String SHAREUSERID = "share";  //分享用户
    public static final String NOTLOGINUSERID_GEN_NEW = "gen_new_";  //未登录用户 创建用户时  partnerUserId  开头是一次为前缀
    private static final String OPENBS_NOT_LOGIN_GEN = "gen_";  // 通过openBs链接产生的用户partnerUserId以"gen_"开头，此类用户按照未登录用户处理

    private Long id;
    private Long appId;
    private String partnerUserId;
    private Long credits; //积分余额
    private String phone; //手机号
    private String alipay; //支付宝账号
    private String qq; //qq号
    private String lastRealname;	//真实姓名
    private String lastPhone; //最后一次使用的手机号
    private String lastAlipay; //最后一次使用的支付宝账号
    private String lastQq; //最后一次使用的qq号

    private String addrName; //收件人名称
    private String addrProvince;
    private String addrCity;
    private String addrPhone;
    private String addrArea;
    private String addrDetail; //详细地址
    private Integer unreadCount;

    private Date gmtCreate;
    private Date gmtModified;

    private Integer vipLevel;

    private Long version;
    private String tbsuffix;

    /**
     * 调用updateAutologinParams方法判断条件，如果参数没有修改，不需要调用
     * 注意：在查询得到ConsumerDto时，这个值很可能为ture，由于dao层调用过了，因此在查询后先调用set方法重置状态
     */
    private boolean needUpdate = false;
    /**
     * 空构造器
     */
    public ConsumerDto() {
    	// Do nothing because of X and Y.
    }
    /**
     * 
     * @param id
     */
    public ConsumerDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }
    /**
     * 
     * @param init4insert
     */
    public ConsumerDto(boolean init4insert) {
        if (init4insert) {
            vipLevel = 0;
            credits = 0L;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
            unreadCount = 0;
        }
    }

    public Long getId() {
        return id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public Long getAppId() {
        return appId;
    }
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    public String getPartnerUserId() {
        return partnerUserId;
    }
    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }
    public Long getCredits() {
        return credits;
    }
    public void setCredits(Long credits) {
        needUpdate |= !equals(this.credits, credits);
        this.credits = credits;
    }
    public String getPhone() {
        return phone;
    }
    public void setPhone(String phone) {
        needUpdate |= !equals(this.phone, phone);
        this.phone = phone;
    }
    public String getAlipay() {
        return alipay;
    }
    public void setAlipay(String alipay) {
        needUpdate |= !equals(this.alipay, alipay);
        this.alipay = alipay;
    }
    public String getQq() {
        return qq;
    }
    public void setQq(String qq) {
        needUpdate |= !equals(this.qq, qq);
        this.qq = qq;
    }
    public String getLastRealname() {
        return lastRealname;
    }
    public void setLastRealname(String lastRealname) {
        this.lastRealname = lastRealname;
    }
    public String getLastPhone() {
        return lastPhone;
    }
    public void setLastPhone(String lastPhone) {
        this.lastPhone = lastPhone;
    }
    public String getLastAlipay() {
        return lastAlipay;
    }
    public void setLastAlipay(String lastAlipay) {
        this.lastAlipay = lastAlipay;
    }
    public String getLastQq() {
        return lastQq;
    }
    public void setLastQq(String lastQq) {
        this.lastQq = lastQq;
    }
    public String getAddrName() {
        return addrName;
    }
    public void setAddrName(String addrName) {
        this.addrName = addrName;
    }
    public String getAddrProvince() {
        return addrProvince;
    }
    public void setAddrProvince(String addrProvince) {
        this.addrProvince = addrProvince;
    }
    public String getAddrCity() {
        return addrCity;
    }
    public void setAddrCity(String addrCity) {
        this.addrCity = addrCity;
    }
    public String getAddrPhone() {
        return addrPhone;
    }
    public void setAddrPhone(String addrPhone) {
        this.addrPhone = addrPhone;
    }
    public String getAddrArea() {
        return addrArea;
    }
    public void setAddrArea(String addrArea) {
        this.addrArea = addrArea;
    }
    public String getAddrDetail() {
        return addrDetail;
    }
    public void setAddrDetail(String addrDetail) {
        this.addrDetail = addrDetail;
    }
    public Date getGmtCreate() {
        return gmtCreate;
    }
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    public Date getGmtModified() {
        return gmtModified;
    }
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getUnreadCount() {
        return unreadCount;
    }

    public void setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
    }

    public Integer getVipLevel() {
        return vipLevel;
    }

    public void setVipLevel(Integer vipLevel) {
        needUpdate |= !equals(this.vipLevel, vipLevel);
        this.vipLevel = vipLevel;
    }
   
	public String getTbsuffix() {
		return tbsuffix;
	}
	public void setTbsuffix(String tbsuffix) {
		this.tbsuffix = tbsuffix;
	}
	public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    private static boolean equals(Object one, Object another) {
        return Objects.equals(one, another);
    }

    public boolean isNeedUpdate() {
        return needUpdate;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    //统一判断是否是 未登录
    public boolean isNotLoginUser(){
    	return this.partnerUserId !=null && (this.partnerUserId.equals(NOTLOGINUSERID)||this.partnerUserId.startsWith(NOTLOGINUSERID_GEN_NEW));
    }

    public static boolean isNotLoginUser(String partnerUserId){
        return StringUtils.isNotBlank(partnerUserId) && (partnerUserId.equals(NOTLOGINUSERID)||partnerUserId.startsWith(NOTLOGINUSERID_GEN_NEW));
    }


    /**
     * 判断用户是否未登录
     */
    public static boolean isNotLoginUserWithGen(String partnerUserId) {
        return StringUtils.isBlank(partnerUserId) || NOTLOGINUSERID.equals(partnerUserId)
                || partnerUserId.startsWith(OPENBS_NOT_LOGIN_GEN);
    }

}
