package cn.com.duiba.consumer.center.api.dto;

import cn.com.duiba.consumer.center.api.enums.AccountStatusEnum;
import cn.com.duiba.consumer.center.api.enums.SourceTypeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liukai
 * @Description:
 * @date 2018/10/10上午11:26
 */
public class ConsumerUnifiledAccoutDto implements Serializable {
    private static final long serialVersionUID = 2600684759671783324L;

    /**
     * id
     */
    private Long id;

    /**
     * idmark工具生产的id
     */
    private Long dcid;

    /**
     * 用户编码，三方app时表示uid，兑吧注册用户时表示手机号，兑吧公众号时表示openId
     */
    private String uid;

    /**
     * 用户来源渠道，1：三方app，2：兑吧公众号，3：兑吧注册用户
     */
    private SourceTypeEnum sourceType;

    /**
     * 三方app在兑吧平台的标识，三方app时填入app_id，兑吧自有时填入"phone"，兑吧公众号时填入公众号的appKey
     */
    private String sourceId;

    /**
     * 兑吧注册用户必填，密匙加密存储
     */
    private String secretCode;

    /**
     * 最后访问时间，登陆时更新
     */
    private Date lastVisitTime;

    /**
     * 账户状态，0：未激活，1：激活
     */
    private AccountStatusEnum enabled;

    /**
     * uid的md5
     */
    private String uidMd5;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public SourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSecretCode() {
        return secretCode;
    }

    public void setSecretCode(String secretCode) {
        this.secretCode = secretCode;
    }

    public Date getLastVisitTime() {
        return lastVisitTime;
    }

    public void setLastVisitTime(Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public AccountStatusEnum getEnabled() {
        return enabled;
    }

    public void setEnabled(AccountStatusEnum enabled) {
        this.enabled = enabled;
    }

    public String getUidMd5() {
        return uidMd5;
    }

    public void setUidMd5(String uidMd5) {
        this.uidMd5 = uidMd5;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getDcid() {
        return dcid;
    }

    public void setDcid(Long dcid) {
        this.dcid = dcid;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
