package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerRelationShipDto;
import cn.com.duiba.consumer.center.api.paramQuery.UserQueryParams;

import java.util.List;

/**
 * @author fengyibo
 * @date 2018/10/16 17:21
 */
@AdvancedFeignClient
public interface RemoteConsumerRelationShipSerivice {

    /**
     * 批量查询用户信息
     * @param appId
     * @param cids
     * @return
     */
    List<ConsumerRelationShipDto> findByAppIdAndCid(Long appId, List<Long> cids);

    /**
     * 根据cid批量查询
     * @param cids
     * @return
     */
    List<ConsumerRelationShipDto> findListByCid(List<Long> cids);

    /**
     * 根据cid查询
     * @param cid
     * @return
     */
    ConsumerRelationShipDto selectByCid(Long cid);

    /**
     * 根据条件分页查询
     * @param params
     * @return
     */
    List<ConsumerRelationShipDto> findConsumerListByPage(UserQueryParams params);

    /**
     * 根据条件查询用户总记录数
     * @param params
     * @return
     */
    Long findConsumerCount(UserQueryParams params);

    /**
     * 更新数据
     * @param dto
     */
    void updateByCid(ConsumerRelationShipDto dto);

}
