package cn.com.duiba.consumer.center.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class UserInitializeInfoDto implements Serializable {

    private static final long serialVersionUID = -3567301526405688956L;
    private Long id;

    /**
    * appId
    */
    private Long appId;

    /**
    * 第三方uid
    */
    private String partnerUid;

    /**
    * 积分值
    */
    private Long point;

    /**
    * 等级
    */
    private String level;

    /**
    * 对应的兑吧这边的用户id
    */
    private Long consumerId;

    /**
    * 其他初始化的一些信息 json格式
    */
    private String extraJson;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * appId+uid md5加密 必填
     */
    private String uidMd5;

    /**
     * 所属支行
     */
    private String branch;

    /**
     * 手机号
     */
    private String mobile;

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public UserInitializeInfoDto() {
    }

    public UserInitializeInfoDto(Long appId, String partnerUid, Long point, String level ,String uidMd5){
        this.appId =appId;
        this.partnerUid = partnerUid;
        this.point = point;
        this.level = level;
        this.uidMd5 = uidMd5;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getPartnerUid() {
        return partnerUid;
    }

    public void setPartnerUid(String partnerUid) {
        this.partnerUid = partnerUid;
    }

    public Long getPoint() {
        return point;
    }

    public void setPoint(Long point) {
        this.point = point;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getUidMd5() {
        return uidMd5;
    }

    public void setUidMd5(String uidMd5) {
        this.uidMd5 = uidMd5;
    }


    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserInitializeInfoDto that = (UserInitializeInfoDto) o;
        return appId.equals(that.appId) &&
                partnerUid.equals(that.partnerUid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, partnerUid);
    }
}