package cn.com.duiba.consumer.center.api.enums;

/**
 * 地址类型枚举
 * Created by lufeng  2018/11/30
 */
public enum AddressTypeEnum {
    HOME(1,"家"),
    COMPANY(2,"公司"),


    OTHER(99,"其他");

    private Integer type;
    private String desc;

    AddressTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static AddressTypeEnum getByType(Integer type){
        for(AddressTypeEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
