package cn.com.duiba.consumer.center.api.enums;

public enum ConsumerUserEnum {

    ORDER_OPT(0,"下订单类型"),
    CREATE_ACCOUNT_OPT(1,"注册账户操作"),
    LOGIN_OPT(1,"登陆操作"),
            ;

    private Integer type;
    private String desc;

    ConsumerUserEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static ConsumerUserEnum getByType(Integer type){
        for(ConsumerUserEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
