package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerFootprintDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 用户兑换足迹服务
 * Created by zhengjy on 2016/12/26.
 */
@AdvancedFeignClient
public interface RemoteConsumerFootPrintService {
    /**
     * 根据消费者ID优先从缓存中查询,若是不存在,从数据库中查询并放入缓存
     *
     * @param consumerId
     * @return 返回整个的实体
     */
    DubboResult<ConsumerFootprintDto> findByConsumerId(Long consumerId);

    /**
     * 根据消费者ID,查询制定字段的数据
     *
     * @param consumerId 消费者ID
     * @param column 期望返回的字段
     * @return
     */
    DubboResult<ConsumerFootprintDto> findByColumnAndConsumerId(Long consumerId, String column);

    /**
     * 根据消费者ID更新用户足迹,并失效缓存
     *
     * @param consumerFootprintDto
     * @return 影响的条数
     */
    DubboResult<Integer> updateByConsumerId(ConsumerFootprintDto consumerFootprintDto);

    /**
     * 根据主键ID更新用户足迹,并失效缓存
     *
     * @param consumerFootprintDto
     * @return
     */
    DubboResult<Integer> update(ConsumerFootprintDto consumerFootprintDto);

    /**
     * 插入新的用户足迹
     *
     * @param consumerFootprintDto
     * @return
     */
    DubboResult<ConsumerFootprintDto> insert(ConsumerFootprintDto consumerFootprintDto);
}
