package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.TrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.param.TrusteeshipCreditsRecordsRollback;

@AdvancedFeignClient
public interface RemoteTrusteeshipCreditsExpandService {

    /**
     * 新增积分
     * 1.同时也会增加累计积分totalCredits字段
     * 2.自动插入records表
     *
     * @return 操作完成后的用户积分,-1表示异常
     */
    Long increaseWithRecord(TrusteeshipCreditsRecordsDto recordsDto) throws BizException;

    /**
     * 扣除积分
     * 1.有可能会失败,请根据返回值判定是否成功
     * 2.自动插入records表
     *
     * @return 操作完成后的流水id, 由于构建biz_id,-1表示异常
     */
    Long decreaseWithRecord(TrusteeshipCreditsRecordsDto recordsDto) throws BizException;

    /**
     * 回滚积分
     * 1.回滚积分
     * 2.更新日志
     *
     * @return
     */
    int rollbackWithRecord(TrusteeshipCreditsRecordsRollback recordsRollback) throws  BizException;
}
