package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.expire.BeAboutExpireCreditsDto;
import cn.com.duiba.credits.credits.center.api.dto.expire.ExpireTrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireQueryConsumerParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireTrusteeshipCreditsRecordsParam;

import java.util.List;

/**
 * @author fss
 */
@AdvancedFeignClient
public interface RemoteExpireTrusteeshipCreditsRecordsService {
    /**
     * 插入
     * 1.除非有必要,否者推荐使用RemoteTrusteeshipCreditsExpandService.increaseWithRecord
     * 改方法会自动插入流水表
     *
     * @param pojo
     * @return id
     */
    Long insert(ExpireTrusteeshipCreditsRecordsDto pojo) throws BizException;

    /**
     * 分页查询
     *
     * @param pojo
     * @return
     */
    List<ExpireTrusteeshipCreditsRecordsDto> selectList(ExpireTrusteeshipCreditsRecordsParam pojo);

    Long count(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 根据id或者orderNum或者bizId查询
     *
     * @param pojo
     * @return
     */
    ExpireTrusteeshipCreditsRecordsDto selectOne(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 修改
     *
     * @param pojo
     * @return
     */
    int updateById(ExpireTrusteeshipCreditsRecordsDto pojo);

    /**
     * 分页查询
     * @param pojo 查询条件
     * @return
     */
    Page<ExpireTrusteeshipCreditsRecordsDto> recordsPageList(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 查询用户即将过期的积分值
     * @param expireQueryConsumerParam
     * @return 即将过期的积分值
     */
    Long queryConsumerBeAboutExpireCredits(ExpireQueryConsumerParam expireQueryConsumerParam);

    /**
     * 查询用户即将过期的积分列表
     * @param expireQueryConsumerParam
     * @return
     */
    BeAboutExpireCreditsDto pageBeAboutExpireCredits(ExpireQueryConsumerParam expireQueryConsumerParam);


    /**
     * 查询活动明细（分页查询）
     *
     * @param pojo
     * @return
     */
    List<ExpireTrusteeshipCreditsRecordsDto> selectActList(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 查询活动明细记录数
     *
     * @param pojo
     * @return
     */
    Long countAct(ExpireTrusteeshipCreditsRecordsParam pojo);
}
