package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.TrusteeshipCreditsFlowDto;

/**
 * Created by zhangyongjie on 2021/8/17 5:13 下午
 */
@AdvancedFeignClient
public interface RemoteTrusteeshipCreditsFlowService {
    /**
     * 保存年度积分记录
     * @param trusteeshipCreditsFlowDto
     * @return id
     */
    Long saveTrusteeshipCreditsFlow(TrusteeshipCreditsFlowDto trusteeshipCreditsFlowDto);

    /**
     * 更新年度积分记录
     * @param trusteeshipCreditsFlowDto
     */
    void updateTrusteeshipCreditsFlow(TrusteeshipCreditsFlowDto trusteeshipCreditsFlowDto);


    /**
     * 查询某位用户年度积分
     * @param appId
     * @param consumerId
     * @param gainTime
     * @return
     */
    TrusteeshipCreditsFlowDto queryByAppIdAndConsumerIdAndYear(Long appId, Long consumerId, Integer gainTime);

    /**
     * 批量清空过期积分
     */
    void batchClearExpireCredits() throws Exception;
}
