package cn.com.duiba.credits.credits.center.api.dto.expire;

import cn.com.duiba.credits.credits.center.api.enums.ExpireCreditsActivitySourceEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author fss
 */
public class ExpireTrusteeshipCreditsRecordsDto implements Serializable {

    private static final long serialVersionUID = 1560416227712L;


    /**
     * 主键
     * <p>
     * isNullAble:0
     */
    private Long id;

    /**
     * appid
     * isNullAble:0
     */
    private Long appId;

    /**
     * 业务类型：加积分／扣积分/ 过期积分（ADD／CONSUME/VIRTUAL_EXCHANGE/EXPIRE）
     * isNullAble:0
     * @see cn.com.duiba.credits.credits.center.api.enums.BizTypeEnum
     */
    private String bizType;

    /**
     * 订单状态：待确认／已完成（PROCESS／FINISH/FAIL）
     * isNullAble:0
     * @see cn.com.duiba.credits.credits.center.api.enums.OrderStatusEnum
     */
    private String orderStatus;

    /**
     * 订单信息（失败时响应失败信息）
     * isNullAble:1
     */
    private String message;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 兑吧订单号
     * isNullAble:0
     */
    private String orderNum;

    /**
     * 需要变动的积分数额
     * isNullAble:0
     */
    private Long credits;

    /**
     * 活动类型(加积分/扣积分的类目，范围不限定，会动态变化)
     * isNullAble:0
     */
    private String activityType;

    /**
     * 兑换项市场价格
     * isNullAble:1
     */
    private Long facePrice;

    /**
     * 兑换商品实际扣除（单位：分）
     * isNullAble:1
     */
    private Long actualPrice;

    /**
     * 用户ip地址
     * isNullAble:1
     */
    private String ip;

    /**
     * 是否待审核 0-不需要审核 1-待审核
     * isNullAble:1
     */
    private Integer waitAudit;

    /**
     * 额外业务参数
     * isNullAble:1
     */
    private String params;

    /**
     * 订单描述
     * isNullAble:1
     */
    private String description;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 积分来源：0线上积分 1线下积分
     */
    private Integer sourceType;

    /**
     * 剩余可用积分
     */
    private Long remainCredits;

    /**
     * 消耗真实积分值
     */
    private Long consumeCredits;

    /**
     * 过期积分值
     */
    private Long expireCredits;

    /**
     * 是否操作过期:0:未操作,1:已操作 注：生成过期记录使用
     */
    private Integer expireStatus;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 子订单号
     */
    private String subOrderNum;

//    /**
//     * app配置的积分过期规则
//     */
//    private AppNewExtraParam appNewExtraParam;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动来源
     *
     * @see ExpireCreditsActivitySourceEnum
     */
    private Integer activitySourceType;

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getActivitySourceType() {
        return activitySourceType;
    }

    public void setActivitySourceType(Integer activitySourceType) {
        this.activitySourceType = activitySourceType;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Long getConsumeCredits() {
        return consumeCredits;
    }

    public void setConsumeCredits(Long consumeCredits) {
        this.consumeCredits = consumeCredits;
    }

//    public AppNewExtraParam getAppNewExtraParam() {
//        return appNewExtraParam;
//    }
//
//    public void setAppNewExtraParam(AppNewExtraParam appNewExtraParam) {
//        this.appNewExtraParam = appNewExtraParam;
//    }

    public String getSubOrderNum() {
        return subOrderNum;
    }

    public void setSubOrderNum(String subOrderNum) {
        this.subOrderNum = subOrderNum;
    }

    public Long getRemainCredits() {
        return remainCredits;
    }

    public void setRemainCredits(Long remainCredits) {
        this.remainCredits = remainCredits;
    }

    public Long getExpireCredits() {
        return expireCredits;
    }

    public void setExpireCredits(Long expireCredits) {
        this.expireCredits = expireCredits;
    }

    public Integer getExpireStatus() {
        return expireStatus;
    }

    public void setExpireStatus(Integer expireStatus) {
        this.expireStatus = expireStatus;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizType() {
        return this.bizType;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return this.consumerId;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getCredits() {
        return this.credits;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setFacePrice(Long facePrice) {
        this.facePrice = facePrice;
    }

    public Long getFacePrice() {
        return this.facePrice;
    }

    public void setActualPrice(Long actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getActualPrice() {
        return this.actualPrice;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setWaitAudit(Integer waitAudit) {
        this.waitAudit = waitAudit;
    }

    public Integer getWaitAudit() {
        return this.waitAudit;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }
}
