package cn.com.duiba.credits.credits.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/6/25 0025 09:51
 */
public enum BizTypeEnum {
    /**
     * 加积分
     */
    ADD,
    /**
     * 扣积分
     */
    CONSUME,
    /**
     * 虚拟商品兑换
     */
    VIRTUAL_EXCHANGE,
    /**
     * 过期
     */
    EXPIRE,
    ;

    private static final String SEPARATOR = "_";

    public String join(Object... args) {
        StringBuilder key = new StringBuilder().append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    public static String getBizTypeDesc(String bizType) {
        if (StringUtils.isEmpty(bizType)) {
            return StringUtils.EMPTY;
        }

        bizType = StringUtils.upperCase(bizType);
        if (BizTypeEnum.ADD.name().equals(bizType) || BizTypeEnum.VIRTUAL_EXCHANGE.name().equals(bizType)) {
            return "加积分";
        }

        if (BizTypeEnum.CONSUME.name().equals(bizType) || BizTypeEnum.EXPIRE.name().equals(bizType)) {
            return "扣积分";
        }
        return StringUtils.EMPTY;
    }

    /**
     * 是否是消耗积分场景
     * @param bizType
     * @return
     */
    public static boolean isDeductType(String bizType) {
        bizType = StringUtils.upperCase(bizType);
        if (BizTypeEnum.CONSUME.name().equals(bizType) || BizTypeEnum.EXPIRE.name().equals(bizType)) {
            return true;
        }

        return false;
    }

}
