package cn.com.duiba.credits.credits.center.api.param.expire;

import cn.com.duiba.api.bo.page.PageQuery;

import java.util.Date;
import java.util.List;

/**
 * @author author
 */
public class ExpireTrusteeshipCreditsRecordsParam extends PageQuery {

    private static final long serialVersionUID = 1560416227712L;


    /**
     * 主键
     * <p>
     * isNullAble:0
     */
    private Long id;

    /**
     * appid
     * isNullAble:0
     */
    private Long appId;

    /**
     * 业务订单号（扣积分流水号）
     * isNullAble:0
     */
    private String bizId;

    /**
     * 业务类型：加积分／扣积分（add／consume）
     * isNullAble:0
     */
    private String bizType;

    /**
     * 业务类型集合
     */
    private List<String> bizTypeList;

    /**
     * 订单状态：待确认／已完成（process／finish）
     * isNullAble:0
     */
    private String orderStatus;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 兑吧订单号
     * isNullAble:0
     */
    private String orderNum;

     /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 业务类型集合
     */
    private List<String> activityTypeList;

    /**
     * 积分过期时间
     */
    private Date expireDate;

    /**
     * 是否需要查询即将过期积分值
     */
    private boolean queryExpireFlag;

    /**
     * 记录ID列表
     */
    private List<Long> recordIds;

    /**
     * 过期状态:0:未过期,1:已过期
     */
    private Integer expireStatus;

    /**
     * 是否排出没有剩余余额记录
     */
    private Boolean excludeNotRemain;

    /**
     * 是否排出排序操作
     */
    private Boolean excludeSort;

    /**
     * 是否部分查询
     */
    private Boolean limitQuery;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动来源
     */
    private Integer activitySourceType;

    private List<String> orderStatusList;

    public List<String> getOrderStatusList() {
        return orderStatusList;
    }

    public void setOrderStatusList(List<String> orderStatusList) {
        this.orderStatusList = orderStatusList;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Integer getActivitySourceType() {
        return activitySourceType;
    }

    public void setActivitySourceType(Integer activitySourceType) {
        this.activitySourceType = activitySourceType;
    }

    public Boolean getLimitQuery() {
        return limitQuery;
    }

    public void setLimitQuery(Boolean limitQuery) {
        this.limitQuery = limitQuery;
    }

    public Boolean getExcludeNotRemain() {
        return excludeNotRemain;
    }

    public void setExcludeNotRemain(Boolean excludeNotRemain) {
        this.excludeNotRemain = excludeNotRemain;
    }

    public Boolean getExcludeSort() {
        return excludeSort;
    }

    public void setExcludeSort(Boolean excludeSort) {
        this.excludeSort = excludeSort;
    }

    public Integer getExpireStatus() {
        return expireStatus;
    }

    public void setExpireStatus(Integer expireStatus) {
        this.expireStatus = expireStatus;
    }

    public List<Long> getRecordIds() {
        return recordIds;
    }

    public void setRecordIds(List<Long> recordIds) {
        this.recordIds = recordIds;
    }

    public boolean isQueryExpireFlag() {
        return queryExpireFlag;
    }

    public void setQueryExpireFlag(boolean queryExpireFlag) {
        this.queryExpireFlag = queryExpireFlag;
    }

    public Date getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public List<String> getActivityTypeList() {
        return activityTypeList;
    }

    public void setActivityTypeList(List<String> activityTypeList) {
        this.activityTypeList = activityTypeList;
    }

    /**
     * 积分来源：0 线上积分 1 线下积分
     */
    private Integer sourceType;

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public List<String> getBizTypeList() {
        return bizTypeList;
    }

    public void setBizTypeList(List<String> bizTypeList) {
        this.bizTypeList = bizTypeList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}
