package cn.com.duiba.credits.credits.center.api.param.expire;

import cn.com.duiba.boot.exception.BizException;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2022/3/7 09
 * @Description:
 */
public class AppNewExtraParam implements Serializable {

    private static final long serialVersionUID = 1850746518480289867L;

    /**
     * 积分过期时间:自获取日起XX天后过期
     */
    private String creditsExpireDay;

    /**
     * 退回积分有效期：0:积分获得日计算;1:积分退回日计算
     */
    private String returnCreditsType;

    public String getCreditsExpireDay() {
        return creditsExpireDay;
    }

    public String getReturnCreditsType() {
        return returnCreditsType;
    }

    /**
     * appNewExtra定义Integer，修改置空后存在默认值0,用String避免这个问题
     * @return
     */
    public Integer getCreditsExpireDayInt() {
        return StringUtils.isEmpty(creditsExpireDay) ? null : Integer.valueOf(creditsExpireDay);
    }

    public void setCreditsExpireDay(String creditsExpireDay) {
        this.creditsExpireDay = creditsExpireDay;
    }

    public Integer getReturnCreditsTypeInt() {
        return StringUtils.isEmpty(returnCreditsType) ? null : Integer.valueOf(returnCreditsType);
    }

    public void setReturnCreditsType(String returnCreditsType) {
        this.returnCreditsType = returnCreditsType;
    }
}
