package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.expire.ExpireTrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.param.expire.AppNewExtraParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireCreditsParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireTrusteeshipCreditsRecordsRollback;

@AdvancedFeignClient
public interface RemoteExpireTrusteeshipCreditsExpandService {

    /**
     * 新增积分
     * 1.同时也会增加累计积分totalCredits字段
     * 2.自动插入records表
     *
     * @return 操作完成后的用户积分,-1表示异常
     */
    Long increaseWithRecord(ExpireTrusteeshipCreditsRecordsDto recordsDto, AppNewExtraParam appNewExtraDto) throws BizException;

    /**
     * 扣除积分
     * 1.有可能会失败,请根据返回值判定是否成功
     * 2.自动插入records表
     *
     * @return 操作完成后的流水id, 由于构建biz_id,-1表示异常
     */
    Long decreaseWithRecord(ExpireTrusteeshipCreditsRecordsDto recordsDto) throws Exception;

    /**
     * 回滚积分
     * 1.回滚积分
     * 2.更新日志
     *
     * @return
     */
    int rollbackWithRecord(ExpireTrusteeshipCreditsRecordsRollback recordsRollback) throws Exception;

    /**
     * 获取用户真实积分(执行过期积分)
     * 特定场景，需要获取当前最新积分使用
     *
     * @param expireCreditsParam
     * @return
     * @throws Exception
     */
    Long getConsumerActualCredits(ExpireCreditsParam expireCreditsParam) throws Exception;

    /**
     * 获取用户已过期积分
     *
     * @param expireCreditsParam
     * @return
     * @throws Exception
     */
    Long getConsumerExpireCredits(ExpireCreditsParam expireCreditsParam) throws Exception;

    /**
     * 新增积分:用于售后部分退款、部分取消发货等场景，通过加积分来回滚积分的逻辑
     * @param recordsDto
     * @return
     * @throws BizException
     */
    Long increaseWithRollBackTypeRecord(ExpireTrusteeshipCreditsRecordsDto recordsDto, AppNewExtraParam appNewExtraDto) throws Exception;
}
