package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.TrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.dto.baosi.TrusteeshipCreditsDayStatisticsDto;
import cn.com.duiba.credits.credits.center.api.dto.baosi.TrusteeshipCreditsUserActualConsumeDto;
import cn.com.duiba.credits.credits.center.api.dto.dalian.CreditStatisticMonthlyDto;
import cn.com.duiba.credits.credits.center.api.param.TrusteeshipCreditsRecordsParam;
import cn.com.duiba.credits.credits.center.api.param.baosi.TrusteeshipCreditsDayStatisticsParam;
import cn.com.duiba.credits.credits.center.api.param.baosi.TrusteeshipCreditsUserActualConsumeParam;
import cn.com.duiba.credits.credits.center.api.param.dalian.DalianUnionQueryParam;

import java.util.List;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/6/17 0017 10:48
 */
@AdvancedFeignClient
public interface RemoteTrusteeshipCreditsRecordsService {
    /**
     * 插入
     * 1.除非有必要,否者推荐使用RemoteTrusteeshipCreditsExpandService.increaseWithRecord
     * 改方法会自动插入流水表
     *
     * @param pojo
     * @return id
     */
    Long insert(TrusteeshipCreditsRecordsDto pojo);

    /**
     * 分页查询
     *
     * @param pojo
     * @return
     */
    List<TrusteeshipCreditsRecordsDto> selectList(TrusteeshipCreditsRecordsParam pojo);

    Long count(TrusteeshipCreditsRecordsParam pojo);

    /**
     * 根据id或者orderNum或者bizId查询
     *
     * @param pojo
     * @return
     */
    TrusteeshipCreditsRecordsDto selectOne(TrusteeshipCreditsRecordsParam pojo);

    /**
     * 修改
     *
     * @param pojo
     * @return
     */
    int updateById(TrusteeshipCreditsRecordsDto pojo);

    /**
     * 分页查询
     * @param pojo 查询条件
     * @return
     */
    Page<TrusteeshipCreditsRecordsDto> recordsPageList(TrusteeshipCreditsRecordsParam pojo);


    /**
     * 大连银联 月份流水
     *
     * @param queryParam 大连银联查询参数
     * @return 流水
     */
    Page<TrusteeshipCreditsRecordsDto> dalianRecordsMonthly(DalianUnionQueryParam queryParam);

    /**
     * 大连银联 月份统计
     *
     * @param queryParam 大连银联查询参数
     * @return 月份统计数据
     */
    List<CreditStatisticMonthlyDto> dalianStaticByMonth(DalianUnionQueryParam queryParam);

    /**
     * 查询用户实际消耗积分数
     * @param pojo
     * @return
     */
    List<TrusteeshipCreditsUserActualConsumeDto> selectUserActualConsumeCredits(TrusteeshipCreditsUserActualConsumeParam pojo);

    /**
     * 条件查询
     * @param queryParam
     * @return
     */
    List<TrusteeshipCreditsRecordsDto> listByCondition(TrusteeshipCreditsRecordsParam queryParam);


    /**
     * 查询日统计消耗积分与增加积分
     * @param pojo
     * @return
     */
    List<TrusteeshipCreditsDayStatisticsDto> selectCreditsDayStatistics(TrusteeshipCreditsDayStatisticsParam pojo);

}
