package cn.com.duiba.creditsclub.ecosphere.sdk;

import cn.com.duiba.creditsclub.ecosphere.sdk.data.UserCreditsLogData;
import cn.com.duiba.creditsclub.ecosphere.sdk.params.ConsumerCreditParam;
import cn.com.duiba.creditsclub.ecosphere.sdk.params.CreditLogQueryParam;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.PageList;

import java.util.Date;
import java.util.List;

/**
 * @Author: daijungang
 * @Date: 2021-01-08 15:09
 * @Description: 用户积分服务API
 * @version: 1.0
 */
public interface ConsumerCreditApi {

    /**
     * 积分变更
     *
     * @param param 积分变更参数
     * @return 变更成功或失败
     */
    boolean alterationCredit(ConsumerCreditParam param);

    /**
     * 积分扣减
     *
     * @param param
     * @return
     */
    boolean submitSubCredits(ConsumerCreditParam param);

    /**
     * 加积分
     *
     * @param param
     * @return
     */
    boolean submitAddCredits(ConsumerCreditParam param);


    /**
     * 处理每日失效积分
     *
     * @param userId
     * @return
     */
    boolean dailyInvalidCreditsCheck(String userId);


    /**
     * 处理每日失效积分
     *
     * @param userId
     * @return
     */
    boolean dailyInvalidCreditsCheck(String userId, String projectId);


    /**
     * 同步历史积分
     *
     * @param userId
     * @param expireTime
     * @return
     */
    boolean historyCreditsSync(String userId, Date expireTime, String orderNum);

    /**
     * 获取用户积分
     *
     * @param userId
     * @return
     */
    long queryUserCredit(Long userId);

    /**
     * 获取用户积分明细
     *
     * @param taskId
     * @return
     */
    List<UserCreditsLogData> queryCreditsLogByTaskId(String taskId);

    /**
     * 分页查询用户积分明细
     *
     * @param creditLogQueryParam
     * @return
     */
    PageList<UserCreditsLogData> pageQueryCreditsLogByCondition(CreditLogQueryParam creditLogQueryParam);

}
